/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.client;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.MouseHelper;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.PlayerRenderer;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.EntityType;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.inventory.container.Slot;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.client.settings.KeyModifier;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.items.CapabilityItemHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackItem;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.BackpackScreen;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.utils.TranslationHelper;
import net.p3pp3rf1y.sophisticatedbackpacks.client.init.ModBlockColors;
import net.p3pp3rf1y.sophisticatedbackpacks.client.init.ModItemColors;
import net.p3pp3rf1y.sophisticatedbackpacks.client.render.BackpackDynamicModel;
import net.p3pp3rf1y.sophisticatedbackpacks.client.render.BackpackLayerRenderer;
import net.p3pp3rf1y.sophisticatedbackpacks.client.render.BackpackTESR;
import net.p3pp3rf1y.sophisticatedbackpacks.client.render.BackpackTooltipRenderer;
import net.p3pp3rf1y.sophisticatedbackpacks.common.CommonProxy;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.BackpackContainer;
import net.p3pp3rf1y.sophisticatedbackpacks.init.ModBlocks;
import net.p3pp3rf1y.sophisticatedbackpacks.init.ModItems;
import net.p3pp3rf1y.sophisticatedbackpacks.network.BackpackCloseMessage;
import net.p3pp3rf1y.sophisticatedbackpacks.network.BackpackOpenMessage;
import net.p3pp3rf1y.sophisticatedbackpacks.network.BlockToolSwapMessage;
import net.p3pp3rf1y.sophisticatedbackpacks.network.EntityToolSwapMessage;
import net.p3pp3rf1y.sophisticatedbackpacks.network.InventoryInteractionMessage;
import net.p3pp3rf1y.sophisticatedbackpacks.network.PacketHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.network.UpgradeToggleMessage;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.battery.BatteryUpgradeContainer;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.jukebox.BackpackSoundHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.tank.TankUpgradeContainer;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.toolswapper.ToolSwapperFilterContainer;
import net.p3pp3rf1y.sophisticatedbackpacks.util.RecipeHelper;
import net.p3pp3rf1y.sophisticatedbackpacks.util.RegistryHelper;
import net.p3pp3rf1y.sophisticatedbackpacks.util.WorldHelper;

public class ClientProxy
extends CommonProxy {
    private static final int KEY_B = 66;
    private static final int KEY_C = 67;
    private static final int KEY_Z = 90;
    private static final int KEY_X = 88;
    private static final int KEY_UNKNOWN = -1;
    private static final int MIDDLE_BUTTON = 2;
    private static final String KEYBIND_SOPHISTICATEDBACKPACKS_CATEGORY = "keybind.sophisticatedbackpacks.category";
    public static final KeyBinding BACKPACK_OPEN_KEYBIND = new KeyBinding(TranslationHelper.translKeybind("open_backpack"), (IKeyConflictContext)BackpackKeyConflictContext.INSTANCE, InputMappings.Type.KEYSYM.func_197944_a(66), "keybind.sophisticatedbackpacks.category");
    public static final KeyBinding INVENTORY_INTERACTION_KEYBIND = new KeyBinding(TranslationHelper.translKeybind("inventory_interaction"), (IKeyConflictContext)KeyConflictContext.IN_GAME, InputMappings.Type.KEYSYM.func_197944_a(67), "keybind.sophisticatedbackpacks.category");
    public static final KeyBinding TOOL_SWAP_KEYBIND = new KeyBinding(TranslationHelper.translKeybind("tool_swap"), (IKeyConflictContext)KeyConflictContext.IN_GAME, InputMappings.Type.KEYSYM.func_197944_a(-1), "keybind.sophisticatedbackpacks.category");
    public static final KeyBinding SORT_KEYBIND = new KeyBinding(TranslationHelper.translKeybind("sort"), (IKeyConflictContext)BackpackGuiKeyConflictContext.INSTANCE, InputMappings.Type.MOUSE.func_197944_a(2), "keybind.sophisticatedbackpacks.category");
    public static final KeyBinding BACKPACK_TOGGLE_UPGRADE_1 = new KeyBinding(TranslationHelper.translKeybind("toggle_upgrade_1"), (IKeyConflictContext)KeyConflictContext.UNIVERSAL, KeyModifier.ALT, InputMappings.Type.KEYSYM.func_197944_a(90), "keybind.sophisticatedbackpacks.category");
    public static final KeyBinding BACKPACK_TOGGLE_UPGRADE_2 = new KeyBinding(TranslationHelper.translKeybind("toggle_upgrade_2"), (IKeyConflictContext)KeyConflictContext.UNIVERSAL, KeyModifier.ALT, InputMappings.Type.KEYSYM.func_197944_a(88), "keybind.sophisticatedbackpacks.category");
    public static final KeyBinding BACKPACK_TOGGLE_UPGRADE_3 = new KeyBinding(TranslationHelper.translKeybind("toggle_upgrade_3"), (IKeyConflictContext)KeyConflictContext.UNIVERSAL, InputMappings.Type.KEYSYM.func_197944_a(-1), "keybind.sophisticatedbackpacks.category");
    public static final KeyBinding BACKPACK_TOGGLE_UPGRADE_4 = new KeyBinding(TranslationHelper.translKeybind("toggle_upgrade_4"), (IKeyConflictContext)KeyConflictContext.UNIVERSAL, InputMappings.Type.KEYSYM.func_197944_a(-1), "keybind.sophisticatedbackpacks.category");
    public static final KeyBinding BACKPACK_TOGGLE_UPGRADE_5 = new KeyBinding(TranslationHelper.translKeybind("toggle_upgrade_5"), (IKeyConflictContext)KeyConflictContext.UNIVERSAL, InputMappings.Type.KEYSYM.func_197944_a(-1), "keybind.sophisticatedbackpacks.category");
    private static final Map<Integer, KeyBinding> UPGRADE_SLOT_TOGGLE_KEYBINDS = ImmutableMap.of((Object)0, (Object)BACKPACK_TOGGLE_UPGRADE_1, (Object)1, (Object)BACKPACK_TOGGLE_UPGRADE_2, (Object)2, (Object)BACKPACK_TOGGLE_UPGRADE_3, (Object)3, (Object)BACKPACK_TOGGLE_UPGRADE_4, (Object)4, (Object)BACKPACK_TOGGLE_UPGRADE_5);

    private static boolean tryCallSort(Screen gui) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71439_g != null && mc.field_71439_g.field_71070_bA instanceof BackpackContainer && gui instanceof BackpackScreen) {
            BackpackScreen screen = (BackpackScreen)gui;
            MouseHelper mh = mc.field_71417_B;
            double mouseX = mh.func_198024_e() * (double)mc.func_228018_at_().func_198107_o() / (double)mc.func_228018_at_().func_198105_m();
            double mouseY = mh.func_198026_f() * (double)mc.func_228018_at_().func_198087_p() / (double)mc.func_228018_at_().func_198083_n();
            BackpackContainer container = (BackpackContainer)mc.field_71439_g.field_71070_bA;
            Slot selectedSlot = screen.func_195360_a(mouseX, mouseY);
            if (selectedSlot != null && !container.isPlayersInventorySlot(selectedSlot.field_75222_d)) {
                container.sort();
                return true;
            }
        }
        return false;
    }

    public static void handleGuiKeyPress(GuiScreenEvent.KeyboardKeyPressedEvent.Pre event) {
        if (SORT_KEYBIND.isActiveAndMatches(InputMappings.func_197954_a((int)event.getKeyCode(), (int)event.getScanCode())) && ClientProxy.tryCallSort(event.getGui())) {
            event.setCanceled(true);
        }
    }

    public static void handleGuiMouseKeyPress(GuiScreenEvent.MouseClickedEvent.Pre event) {
        if (SORT_KEYBIND.isActiveAndMatches(InputMappings.Type.MOUSE.func_197944_a(event.getButton())) && ClientProxy.tryCallSort(event.getGui())) {
            event.setCanceled(true);
        }
    }

    public static void handleKeyInputEvent(TickEvent.ClientTickEvent event) {
        if (BACKPACK_OPEN_KEYBIND.func_151468_f()) {
            ClientProxy.sendBackpackOpenOrCloseMessage();
        } else if (INVENTORY_INTERACTION_KEYBIND.func_151468_f()) {
            ClientProxy.sendInteractWithInventoryMessage();
        } else if (TOOL_SWAP_KEYBIND.func_151468_f()) {
            ClientProxy.sendToolSwapMessage();
        } else {
            for (Map.Entry<Integer, KeyBinding> slotKeybind : UPGRADE_SLOT_TOGGLE_KEYBINDS.entrySet()) {
                if (!slotKeybind.getValue().func_151468_f()) continue;
                PacketHandler.sendToServer(new UpgradeToggleMessage(slotKeybind.getKey()));
            }
        }
    }

    private static void sendToolSwapMessage() {
        Minecraft mc = Minecraft.func_71410_x();
        ClientPlayerEntity player = mc.field_71439_g;
        if (player == null || mc.field_71476_x == null) {
            return;
        }
        if (player.func_184614_ca().func_77973_b() instanceof BackpackItem) {
            player.func_146105_b((ITextComponent)new TranslationTextComponent("gui.sophisticatedbackpacks.status.unable_to_swap_tool_for_backpack"), true);
            return;
        }
        RayTraceResult rayTrace = mc.field_71476_x;
        if (rayTrace.func_216346_c() == RayTraceResult.Type.BLOCK) {
            BlockRayTraceResult blockRayTraceResult = (BlockRayTraceResult)rayTrace;
            BlockPos pos = blockRayTraceResult.func_216350_a();
            PacketHandler.sendToServer(new BlockToolSwapMessage(pos));
        } else if (rayTrace.func_216346_c() == RayTraceResult.Type.ENTITY) {
            EntityRayTraceResult entityRayTraceResult = (EntityRayTraceResult)rayTrace;
            PacketHandler.sendToServer(new EntityToolSwapMessage(entityRayTraceResult.func_216348_a().func_145782_y()));
        }
    }

    private static void sendInteractWithInventoryMessage() {
        Minecraft mc = Minecraft.func_71410_x();
        RayTraceResult rayTrace = mc.field_71476_x;
        if (rayTrace == null || rayTrace.func_216346_c() != RayTraceResult.Type.BLOCK) {
            return;
        }
        BlockRayTraceResult blockraytraceresult = (BlockRayTraceResult)rayTrace;
        BlockPos pos = blockraytraceresult.func_216350_a();
        if (!WorldHelper.getTile((IBlockReader)mc.field_71441_e, pos, TileEntity.class).map(te -> te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).isPresent()).orElse(false).booleanValue()) {
            return;
        }
        PacketHandler.sendToServer(new InventoryInteractionMessage(pos, blockraytraceresult.func_216354_b()));
    }

    private static void sendBackpackOpenOrCloseMessage() {
        if (!KeyConflictContext.GUI.isActive()) {
            PacketHandler.sendToServer(new BackpackOpenMessage());
        } else if (Minecraft.func_71410_x().field_71462_r instanceof BackpackScreen) {
            BackpackScreen backpackScreen = (BackpackScreen)Minecraft.func_71410_x().field_71462_r;
            Slot slot = backpackScreen.getSlotUnderMouse();
            if (slot != null && slot.func_75211_c().func_77973_b() instanceof BackpackItem) {
                PacketHandler.sendToServer(new BackpackOpenMessage(slot.field_75222_d));
            } else {
                PacketHandler.sendToServer(new BackpackCloseMessage());
            }
        }
    }

    @Override
    public void registerHandlers() {
        super.registerHandlers();
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        modBus.addListener(this::loadComplete);
        modBus.addListener(this::clientSetup);
        modBus.addListener(this::stitchTextures);
        modBus.addListener(this::onModelRegistry);
        IEventBus eventBus = MinecraftForge.EVENT_BUS;
        eventBus.addListener(ClientProxy::handleKeyInputEvent);
        eventBus.addListener(EventPriority.HIGH, ClientProxy::handleGuiMouseKeyPress);
        eventBus.addListener(EventPriority.HIGH, ClientProxy::handleGuiKeyPress);
        eventBus.addListener(ClientProxy::onPlayerJoinServer);
        eventBus.addListener(BackpackTooltipRenderer::renderBackpackTooltip);
        eventBus.addListener(BackpackTooltipRenderer::onWorldLoad);
        eventBus.addListener(BackpackSoundHandler::tick);
        eventBus.addListener(BackpackSoundHandler::onWorldUnload);
    }

    private void loadComplete(FMLLoadCompleteEvent event) {
        event.enqueueWork(() -> {
            ModItemColors.init();
            ModBlockColors.init();
            this.registerBackpackLayer();
        });
    }

    private void onModelRegistry(ModelRegistryEvent event) {
        ModelLoaderRegistry.registerLoader((ResourceLocation)RegistryHelper.getRL("backpack"), (IModelLoader)BackpackDynamicModel.Loader.INSTANCE);
    }

    private void clientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            ClientRegistry.registerKeyBinding((KeyBinding)BACKPACK_OPEN_KEYBIND);
            ClientRegistry.registerKeyBinding((KeyBinding)INVENTORY_INTERACTION_KEYBIND);
            ClientRegistry.registerKeyBinding((KeyBinding)TOOL_SWAP_KEYBIND);
            ClientRegistry.registerKeyBinding((KeyBinding)SORT_KEYBIND);
            UPGRADE_SLOT_TOGGLE_KEYBINDS.forEach((slot, keybind) -> ClientRegistry.registerKeyBinding((KeyBinding)keybind));
        });
        RenderTypeLookup.setRenderLayer((Block)((Block)ModBlocks.BACKPACK.get()), (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)((Block)ModBlocks.IRON_BACKPACK.get()), (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)((Block)ModBlocks.GOLD_BACKPACK.get()), (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)((Block)ModBlocks.DIAMOND_BACKPACK.get()), (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)((Block)ModBlocks.NETHERITE_BACKPACK.get()), (RenderType)RenderType.func_228643_e_());
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)ModItems.EVERLASTING_BACKPACK_ITEM_ENTITY.get()), renderManager -> new ItemRenderer(renderManager, Minecraft.func_71410_x().func_175599_af()));
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)ModBlocks.BACKPACK_TILE_TYPE.get()), BackpackTESR::new);
    }

    private void registerBackpackLayer() {
        EntityRendererManager renderManager = Minecraft.func_71410_x().func_175598_ae();
        Map skinMap = renderManager.getSkinMap();
        PlayerRenderer render = (PlayerRenderer)skinMap.get("default");
        render.func_177094_a(new BackpackLayerRenderer(render));
        render = (PlayerRenderer)skinMap.get("slim");
        render.func_177094_a(new BackpackLayerRenderer(render));
        renderManager.field_78729_o.forEach((e, r) -> {
            if (r instanceof LivingRenderer) {
                ((LivingRenderer)r).func_177094_a(new BackpackLayerRenderer((LivingRenderer)r));
            }
        });
    }

    public void stitchTextures(TextureStitchEvent.Pre evt) {
        if (evt.getMap().func_229223_g_() == PlayerContainer.field_226615_c_) {
            evt.addSprite(BackpackContainer.EMPTY_UPGRADE_SLOT_BACKGROUND);
            evt.addSprite(ToolSwapperFilterContainer.EMPTY_WEAPON_SLOT_BACKGROUND);
            ToolSwapperFilterContainer.EMPTY_TOOL_SLOT_BACKGROUNDS.values().forEach(arg_0 -> ((TextureStitchEvent.Pre)evt).addSprite(arg_0));
            evt.addSprite(TankUpgradeContainer.EMPTY_TANK_INPUT_SLOT_BACKGROUND);
            evt.addSprite(TankUpgradeContainer.EMPTY_TANK_OUTPUT_SLOT_BACKGROUND);
            evt.addSprite(BatteryUpgradeContainer.EMPTY_BATTERY_INPUT_SLOT_BACKGROUND);
            evt.addSprite(BatteryUpgradeContainer.EMPTY_BATTERY_OUTPUT_SLOT_BACKGROUND);
        }
    }

    private static void onPlayerJoinServer(ClientPlayerNetworkEvent.LoggedInEvent evt) {
        RecipeHelper.setWorld((World)Minecraft.func_71410_x().field_71441_e);
    }

    private static class BackpackGuiKeyConflictContext
    implements IKeyConflictContext {
        public static final BackpackGuiKeyConflictContext INSTANCE = new BackpackGuiKeyConflictContext();

        private BackpackGuiKeyConflictContext() {
        }

        public boolean isActive() {
            return KeyConflictContext.GUI.isActive() && Minecraft.func_71410_x().field_71462_r instanceof BackpackScreen;
        }

        public boolean conflicts(IKeyConflictContext other) {
            return this == other;
        }
    }

    private static class BackpackKeyConflictContext
    implements IKeyConflictContext {
        public static final BackpackKeyConflictContext INSTANCE = new BackpackKeyConflictContext();

        private BackpackKeyConflictContext() {
        }

        public boolean isActive() {
            return !KeyConflictContext.GUI.isActive() || Minecraft.func_71410_x().field_71462_r instanceof BackpackScreen;
        }

        public boolean conflicts(IKeyConflictContext other) {
            return this == other;
        }
    }
}

